/* - FCCountListener -
 * Display the count data after a count change
 *
 * Copyright 2011 Phidgets Inc.
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License.
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */
package listeners;

import com.phidgets.FrequencyCounterPhidget;
import com.phidgets.PhidgetException;
import com.phidgets.event.FrequencyCounterCountListener;
import com.phidgets.event.FrequencyCounterCountEvent;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.JComboBox;

public class FCCountListener implements FrequencyCounterCountListener {

    private JFrame appFrame;
    private JComboBox channelCmb;
    private JTextField countTxt;
    private JTextField timeTxt;
    private JTextField frequencyTxt;
    private JTextField totalCountTxt;
    private JTextField totalTimeTxt;

    public FCCountListener(JComboBox channelCmb, JTextField countTxt, JTextField timeTxt, JTextField frequencyTxt, JTextField totalCountTxt, JTextField totalTimeTxt) {
        this.channelCmb = channelCmb;
        this.countTxt = countTxt;
        this.timeTxt = timeTxt;
        this.frequencyTxt = frequencyTxt;
        this.totalCountTxt = totalCountTxt;
        this.totalTimeTxt = totalTimeTxt;
    }

    public void frequencyCounterCounted(FrequencyCounterCountEvent fcce) {
        FrequencyCounterPhidget fc = (FrequencyCounterPhidget) fcce.getSource();
   
        if (fcce.getIndex() == ((Integer) channelCmb.getSelectedItem()).intValue()) {
            try {  
                countTxt.setText(Integer.toString(fcce.getCount()));
                timeTxt.setText(Integer.toString(fcce.getTime() / 1000));
                frequencyTxt.setText(Double.toString(fc.getFrequency(((Integer) channelCmb.getSelectedItem()).intValue())));
                totalCountTxt.setText(Long.toString(fc.getTotalCount(((Integer) channelCmb.getSelectedItem()).intValue())));
                totalTimeTxt.setText(Long.toString(fc.getTotalTime(((Integer) channelCmb.getSelectedItem()).intValue()) / 1000));

            } catch (PhidgetException ex) {
                JOptionPane.showMessageDialog(appFrame, ex.getDescription(), "Phidget error " + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
            }
        }

    }
}
